<?php
require_once __DIR__ . '/../includes/functions.php';

// 检查是否登录且是管理员
if (!isLoggedIn() || !isAdmin()) {
    setFlashMessage('error', '您没有权限访问管理后台');
    redirect(SITE_URL . '/index.php');
}

$user = getCurrentUser();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? e($pageTitle) . ' - ' : ''; ?>管理后台 - <?php echo e(getSetting('site_name', 'PHP论坛')); ?></title>
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/assets/css/style.css">
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/assets/css/admin.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="admin-body">
    <div class="admin-wrapper">
        <!-- 侧边栏 -->
        <aside class="admin-sidebar">
            <div class="sidebar-header">
                <a href="<?php echo SITE_URL; ?>/admin/" class="logo">
                    <i class="fas fa-cog"></i>
                    <span>管理后台</span>
                </a>
            </div>
            <nav class="sidebar-nav">
                <a href="<?php echo SITE_URL; ?>/admin/" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>仪表盘</span>
                </a>
                <a href="<?php echo SITE_URL; ?>/admin/posts.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'posts.php' ? 'active' : ''; ?>">
                    <i class="fas fa-file-alt"></i>
                    <span>帖子管理</span>
                </a>
                <a href="<?php echo SITE_URL; ?>/admin/categories.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'categories.php' ? 'active' : ''; ?>">
                    <i class="fas fa-folder"></i>
                    <span>板块管理</span>
                </a>
                <a href="<?php echo SITE_URL; ?>/admin/users.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : ''; ?>">
                    <i class="fas fa-users"></i>
                    <span>用户管理</span>
                </a>
                <a href="<?php echo SITE_URL; ?>/admin/medals.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'medals.php' ? 'active' : ''; ?>">
                    <i class="fas fa-medal"></i>
                    <span>勋章管理</span>
                </a>
                <a href="<?php echo SITE_URL; ?>/admin/settings.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'active' : ''; ?>">
                    <i class="fas fa-cog"></i>
                    <span>系统设置</span>
                </a>
            </nav>
        </aside>

        <!-- 主内容区 -->
        <div class="admin-main">
            <!-- 顶部导航 -->
            <header class="admin-header">
                <div class="header-left">
                    <button class="sidebar-toggle" onclick="document.body.classList.toggle('sidebar-collapsed')">
                        <i class="fas fa-bars"></i>
                    </button>
                </div>
                <div class="header-right">
                    <a href="<?php echo SITE_URL; ?>/index.php" target="_blank" class="header-link">
                        <i class="fas fa-home"></i> 访问前台
                    </a>
                    <div class="user-menu">
                        <span><?php echo e($user['username']); ?></span>
                        <a href="<?php echo SITE_URL; ?>/logout.php" class="header-link">
                            <i class="fas fa-sign-out-alt"></i> 退出
                        </a>
                    </div>
                </div>
            </header>

            <!-- 内容区域 -->
            <main class="admin-container">
                <?php
                $flash = getFlashMessage();
                if ($flash):
                ?>
                    <div class="alert alert-<?php echo $flash['type']; ?>">
                        <?php echo e($flash['message']); ?>
                    </div>
                <?php endif; ?>
