<?php
/**
 * 管理后台首页
 */
require_once __DIR__ . '/../includes/functions.php';

// 检查是否登录且是管理员
if (!isLoggedIn() || !isAdmin()) {
    setFlashMessage('error', '您没有权限访问管理后台');
    redirect(SITE_URL . '/index.php');
}

// 获取统计数据
$stats = [
    'users' => db()->queryOne("SELECT COUNT(*) as count FROM users")['count'],
    'posts' => db()->queryOne("SELECT COUNT(*) as count FROM posts WHERE status = 1")['count'],
    'replies' => db()->queryOne("SELECT COUNT(*) as count FROM replies WHERE status = 1")['count'],
    'categories' => db()->queryOne("SELECT COUNT(*) as count FROM categories")['count'],
];

// 获取最新用户
$latestUsers = db()->query("SELECT * FROM users ORDER BY created_at DESC LIMIT 5");

// 获取最新帖子
$latestPosts = db()->query(
    "SELECT p.*, u.username, c.name as category_name 
     FROM posts p 
     LEFT JOIN users u ON p.user_id = u.id 
     LEFT JOIN categories c ON p.category_id = c.id 
     ORDER BY p.created_at DESC LIMIT 5"
);

$pageTitle = '管理后台';
include __DIR__ . '/header.php';
?>

<div class="admin-content">
    <h1>仪表盘</h1>
    
    <div class="stats-grid">
        <a href="users.php" class="stat-card">
            <div class="stat-icon"><i class="fas fa-users"></i></div>
            <div class="stat-info">
                <h3><?php echo $stats['users']; ?></h3>
                <p>注册用户</p>
            </div>
        </a>
        <a href="posts.php" class="stat-card">
            <div class="stat-icon"><i class="fas fa-file-alt"></i></div>
            <div class="stat-info">
                <h3><?php echo $stats['posts']; ?></h3>
                <p>帖子数量</p>
            </div>
        </a>
        <a href="replies.php" class="stat-card">
            <div class="stat-icon"><i class="fas fa-comment"></i></div>
            <div class="stat-info">
                <h3><?php echo $stats['replies']; ?></h3>
                <p>回复数量</p>
            </div>
        </a>
        <a href="categories.php" class="stat-card">
            <div class="stat-icon"><i class="fas fa-folder"></i></div>
            <div class="stat-info">
                <h3><?php echo $stats['categories']; ?></h3>
                <p>板块数量</p>
            </div>
        </a>
    </div>

    <div class="admin-sections">
        <div class="admin-section">
            <h2>最新用户</h2>
            <table class="admin-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>用户名</th>
                        <th>邮箱</th>
                        <th>注册时间</th>
                        <th>操作</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($latestUsers as $user): ?>
                    <tr>
                        <td><?php echo $user['id']; ?></td>
                        <td><?php echo e($user['username']); ?></td>
                        <td><?php echo e($user['email']); ?></td>
                        <td><?php echo formatTime($user['created_at']); ?></td>
                        <td>
                            <a href="../user.php?id=<?php echo $user['id']; ?>" target="_blank">查看</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="admin-section">
            <h2>最新帖子</h2>
            <table class="admin-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>标题</th>
                        <th>作者</th>
                        <th>板块</th>
                        <th>时间</th>
                        <th>操作</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($latestPosts as $post): ?>
                    <tr>
                        <td><?php echo $post['id']; ?></td>
                        <td><?php echo e(truncate($post['title'], 30)); ?></td>
                        <td><?php echo e($post['username']); ?></td>
                        <td><?php echo e($post['category_name']); ?></td>
                        <td><?php echo formatTime($post['created_at']); ?></td>
                        <td>
                            <a href="../post.php?id=<?php echo $post['id']; ?>" target="_blank">查看</a>
                            <a href="posts.php?action=delete&id=<?php echo $post['id']; ?>" class="text-danger" onclick="return confirm('确定要删除吗？')">删除</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
