<?php
/**
 * 回复管理
 */
require_once __DIR__ . '/../includes/functions.php';

// 检查是否登录且是管理员
if (!isLoggedIn() || !isAdmin()) {
    setFlashMessage('error', '您没有权限访问此页面');
    redirect(SITE_URL . '/index.php');
}

$action = $_GET['action'] ?? 'list';

// 删除回复
if ($action === 'delete' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    
    $reply = db()->queryOne("SELECT * FROM replies WHERE id = ?", [$id]);
    if ($reply) {
        db()->execute("UPDATE replies SET status = 0 WHERE id = ?", [$id]);
        
        // 更新用户回复数
        db()->execute("UPDATE users SET reply_count = reply_count - 1 WHERE id = ?", [$reply['user_id']]);
        
        // 更新帖子回复数
        db()->execute("UPDATE posts SET reply_count = reply_count - 1 WHERE id = ?", [$reply['post_id']]);
        
        setFlashMessage('success', '回复已删除');
    } else {
        setFlashMessage('error', '回复不存在');
    }
    redirect(SITE_URL . '/admin/replies.php');
}

// 获取回复列表
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$perPage = 20;
$offset = ($page - 1) * $perPage;

$replies = db()->query(
    "SELECT r.*, u.username, p.title as post_title 
     FROM replies r 
     LEFT JOIN users u ON r.user_id = u.id 
     LEFT JOIN posts p ON r.post_id = p.id 
     WHERE r.status = 1 
     ORDER BY r.created_at DESC 
     LIMIT ? OFFSET ?",
    [$perPage, $offset]
);

$totalResult = db()->queryOne("SELECT COUNT(*) as total FROM replies WHERE status = 1");
$total = $totalResult['total'];

$pageTitle = '回复管理';
include __DIR__ . '/header.php';
?>

<div class="admin-content">
    <h1>回复管理</h1>
    
    <div class="admin-section">
        <table class="admin-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>用户</th>
                    <th>帖子</th>
                    <th>内容</th>
                    <th>楼层</th>
                    <th>时间</th>
                    <th>操作</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($replies as $reply): ?>
                <tr>
                    <td><?php echo $reply['id']; ?></td>
                    <td><a href="../user.php?id=<?php echo $reply['user_id']; ?>" target="_blank"><?php echo e($reply['username']); ?></a></td>
                    <td><a href="../post.php?id=<?php echo $reply['post_id']; ?>" target="_blank"><?php echo e(truncate($reply['post_title'], 30)); ?></a></td>
                    <td><?php echo e(truncate($reply['content'], 50)); ?></td>
                    <td><?php echo $reply['floor_number']; ?>楼</td>
                    <td><?php echo formatTime($reply['created_at']); ?></td>
                    <td>
                        <a href="reply-edit.php?id=<?php echo $reply['id']; ?>">编辑</a>
                        <a href="../post.php?id=<?php echo $reply['post_id']; ?>#reply-<?php echo $reply['id']; ?>" target="_blank">查看</a>
                        <a href="?action=delete&id=<?php echo $reply['id']; ?>" class="text-danger" onclick="return confirm('确定要删除吗？')">删除</a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <?php if ($total > $perPage): ?>
            <?php echo pagination($total, $page, $perPage, 'replies.php'); ?>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
