<?php
/**
 * 系统设置
 */
require_once __DIR__ . '/../includes/functions.php';

// 检查是否登录且是管理员
if (!isLoggedIn() || !isAdmin()) {
    setFlashMessage('error', '您没有权限访问此页面');
    redirect(SITE_URL . '/index.php');
}

// 保存设置
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $settings = [
        'site_name' => trim($_POST['site_name'] ?? ''),
        'site_description' => trim($_POST['site_description'] ?? ''),
        'site_keywords' => trim($_POST['site_keywords'] ?? ''),
        'posts_per_page' => intval($_POST['posts_per_page'] ?? 20),
        'replies_per_page' => intval($_POST['replies_per_page'] ?? 20),
        'allow_register' => intval($_POST['allow_register'] ?? 1),
    ];
    
    foreach ($settings as $key => $value) {
        db()->execute(
            "INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) 
             ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)",
            [$key, $value]
        );
    }
    
    setFlashMessage('success', '设置已保存');
    redirect(SITE_URL . '/admin/settings.php');
}

// 获取当前设置
$settings = [];
$rows = db()->query("SELECT * FROM settings");
foreach ($rows as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$pageTitle = '系统设置';
include __DIR__ . '/header.php';
?>

<div class="admin-content">
    <h1>系统设置</h1>
    
    <div class="admin-sections">
        <div class="admin-section">
            <h2>基本设置</h2>
            <form method="POST" action="" class="admin-form">
                <div class="form-group">
                    <label>网站名称</label>
                    <input type="text" name="site_name" class="form-control" 
                           value="<?php echo e($settings['site_name'] ?? 'EchoX'); ?>">
                </div>
                
                <div class="form-group">
                    <label>网站描述</label>
                    <textarea name="site_description" class="form-control" rows="2"><?php echo e($settings['site_description'] ?? ''); ?></textarea>
                </div>
                
                <div class="form-group">
                    <label>网站关键词</label>
                    <input type="text" name="site_keywords" class="form-control" 
                           value="<?php echo e($settings['site_keywords'] ?? ''); ?>">
                    <small class="form-text">用逗号分隔</small>
                </div>
                
                <div class="form-group">
                    <label>每页帖子数</label>
                    <input type="number" name="posts_per_page" class="form-control" 
                           value="<?php echo e($settings['posts_per_page'] ?? '20'); ?>">
                </div>
                
                <div class="form-group">
                    <label>每页回复数</label>
                    <input type="number" name="replies_per_page" class="form-control" 
                           value="<?php echo e($settings['replies_per_page'] ?? '20'); ?>">
                </div>
                
                <div class="form-group">
                    <label>允许注册</label>
                    <select name="allow_register" class="form-control">
                        <option value="1" <?php echo ($settings['allow_register'] ?? '1') == '1' ? 'selected' : ''; ?>>允许</option>
                        <option value="0" <?php echo ($settings['allow_register'] ?? '1') == '0' ? 'selected' : ''; ?>>禁止</option>
                    </select>
                </div>
                
                <button type="submit" class="btn btn-primary">保存设置</button>
            </form>
        </div>
        
        <div class="admin-section">
            <h2>系统信息</h2>
            <table class="admin-table">
                <tr>
                    <td>PHP 版本</td>
                    <td><?php echo PHP_VERSION; ?></td>
                </tr>
                <tr>
                    <td>数据库版本</td>
                    <td>
                        <?php
                        $dbVersion = db()->queryOne("SELECT VERSION() as version");
                        echo $dbVersion['version'];
                        ?>
                    </td>
                </tr>
                <tr>
                    <td>当前时间</td>
                    <td><?php echo date('Y-m-d H:i:s'); ?></td>
                </tr>
                <tr>
                    <td>用户总数</td>
                    <td><?php echo db()->queryOne("SELECT COUNT(*) as count FROM users")['count']; ?></td>
                </tr>
                <tr>
                    <td>帖子总数</td>
                    <td><?php echo db()->queryOne("SELECT COUNT(*) as count FROM posts WHERE status = 1")['count']; ?></td>
                </tr>
                <tr>
                    <td>回复总数</td>
                    <td><?php echo db()->queryOne("SELECT COUNT(*) as count FROM replies WHERE status = 1")['count']; ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
