<?php
/**
 * 数据库升级脚本
 */
require_once __DIR__ . '/../includes/functions.php';

// 检查是否登录且是管理员
if (!isLoggedIn() || !isAdmin()) {
    setFlashMessage('error', '您没有权限');
    redirect(SITE_URL . '/index.php');
}

$message = '';

try {
    // 检查字段是否已存在
    $result = db()->queryOne("SHOW COLUMNS FROM posts LIKE 'is_locked'");
    
    if (!$result) {
        // 添加 is_locked 字段
        db()->execute("ALTER TABLE posts ADD COLUMN is_locked TINYINT UNSIGNED DEFAULT 0 COMMENT '是否锁定: 0否, 1是' AFTER is_essence");
        
        // 添加索引
        db()->execute("ALTER TABLE posts ADD INDEX idx_is_locked (is_locked)");
        
        $message = '✓ 数据库升级成功！已添加 is_locked 字段到 posts 表。';
    } else {
        $message = '✓ 字段已存在，无需升级。';
    }
} catch (Exception $e) {
    $message = '✗ 升级失败：' . $e->getMessage();
}

$pageTitle = '数据库升级';
include __DIR__ . '/header.php';
?>

<div class="admin-content">
    <h1>数据库升级</h1>
    
    <div class="admin-section">
        <div style="padding: 20px; background: #f8f9fa; border-radius: 4px; margin-bottom: 20px;">
            <?php echo e($message); ?>
        </div>
        <a href="posts.php" class="btn btn-primary">返回帖子管理</a>
    </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
