<?php
/**
 * 板块页面 - 显示所有板块列表或单个板块详情
 */
require_once __DIR__ . '/includes/functions.php';

$categoryId = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($categoryId > 0) {
    // 显示单个板块详情
    showCategoryDetail($categoryId);
} else {
    // 显示所有板块列表
    showCategoryList();
}

// 显示板块列表
function showCategoryList() {
    // 获取所有板块
    $categories = db()->query(
        "SELECT c.*, 
                (SELECT COUNT(*) FROM posts WHERE category_id = c.id AND status = 1) as post_count,
                (SELECT COUNT(*) FROM posts WHERE category_id = c.id AND status = 1 AND created_at > DATE_SUB(NOW(), INTERVAL 24 HOUR)) as today_count
         FROM categories c 
         WHERE c.status = 1 
         ORDER BY c.sort_order ASC, c.id ASC"
    );
    
    $pageTitle = '所有板块';
    include __DIR__ . '/templates/header.php';
    ?>

<div class="card">
    <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
        <h2><i class="fas fa-th-large"></i> 所有板块</h2>
        <?php
        $currentUser = getCurrentUser();
        if ($currentUser && $currentUser['role'] >= 1): ?>
            <a href="admin/categories.php" class="btn btn-outline">
                <i class="fas fa-cog"></i> 管理板块
            </a>
        <?php endif; ?>
    </div>
    <div style="padding: 20px;">
        <?php if (empty($categories)): ?>
            <div style="text-align: center; padding: 40px; color: #666;">
                <i class="fas fa-folder-open" style="font-size: 48px; margin-bottom: 15px;"></i>
                <p>暂无板块</p>
            </div>
        <?php else: ?>
            <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 20px;">
                <?php foreach ($categories as $category): ?>
                    <div style="border: 1px solid #e0e0e0; border-radius: 8px; padding: 20px; background: #fff; transition: box-shadow 0.2s;" 
                         onmouseover="this.style.boxShadow='0 2px 8px rgba(0,0,0,0.1)'" 
                         onmouseout="this.style.boxShadow='none'">
                        <div style="display: flex; align-items: center; gap: 12px; margin-bottom: 10px;">
                            <div style="width: 48px; height: 48px; background: #3498db; border-radius: 8px; display: flex; align-items: center; justify-content: center; color: white; font-size: 24px;">
                                <i class="fas <?php echo e($category['icon'] ?: 'fa-folder'); ?>"></i>
                            </div>
                            <div style="flex: 1;">
                                <h3 style="margin: 0; font-size: 18px;">
                                    <a href="category.php?id=<?php echo $category['id']; ?>" style="color: #333; text-decoration: none;">
                                        <?php echo e($category['name']); ?>
                                    </a>
                                </h3>
                                <div style="color: #999; font-size: 13px; margin-top: 4px;">
                                    帖子: <?php echo $category['post_count']; ?>
                                    <?php if ($category['today_count'] > 0): ?>
                                        <span style="color: #e74c3c;">(今日 +<?php echo $category['today_count']; ?>)</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <p style="color: #666; font-size: 14px; margin: 0; line-height: 1.5;">
                            <?php echo e($category['description'] ?: '暂无描述'); ?>
                        </p>
                        <div style="margin-top: 15px; text-align: right;">
                            <a href="category.php?id=<?php echo $category['id']; ?>" class="btn btn-sm btn-outline">
                                进入板块 <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

    <?php
    include __DIR__ . '/templates/footer.php';
}

// 显示单个板块详情
function showCategoryDetail($categoryId) {
    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
    
    // 获取板块信息
    $category = db()->queryOne(
        "SELECT * FROM categories WHERE id = ? AND status = 1",
        [$categoryId]
    );
    
    if (!$category) {
        setFlashMessage('error', '板块不存在或已被删除');
        redirect(SITE_URL . '/category.php');
    }
    
    // 每页帖子数
    $perPage = intval(getSetting('posts_per_page', 20));
    $offset = ($page - 1) * $perPage;
    
    // 获取帖子总数
    $totalResult = db()->queryOne(
        "SELECT COUNT(*) as total FROM posts WHERE category_id = ? AND status = 1",
        [$categoryId]
    );
    $total = $totalResult['total'];
    
    // 获取帖子列表
    $posts = db()->query(
        "SELECT p.*, u.username, u.avatar 
         FROM posts p 
         LEFT JOIN users u ON p.user_id = u.id 
         WHERE p.category_id = ? AND p.status = 1 
         ORDER BY p.is_top DESC, p.last_reply_at DESC, p.created_at DESC 
         LIMIT ? OFFSET ?",
        [$categoryId, $perPage, $offset]
    );
    
    $pageTitle = $category['name'];
    include __DIR__ . '/templates/header.php';
    ?>

<div class="card">
    <div class="card-header">
        <div>
            <h2>
                <i class="fas <?php echo e($category['icon'] ?: 'fa-folder'); ?>"></i>
                <?php echo e($category['name']); ?>
            </h2>
            <p style="margin-top: 5px; color: #666; font-size: 14px;">
                <?php echo e($category['description']); ?>
            </p>
        </div>
        <div style="display: flex; gap: 10px;">
            <?php
            $currentUser = getCurrentUser();
            if ($currentUser && $currentUser['role'] >= 1): ?>
                <a href="admin/categories.php?action=edit&id=<?php echo $categoryId; ?>" class="btn btn-outline">
                    <i class="fas fa-edit"></i> 编辑板块
                </a>
            <?php endif; ?>
            <?php if (isLoggedIn()): ?>
                <a href="create-post.php?category=<?php echo $categoryId; ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> 发帖
                </a>
            <?php endif; ?>
        </div>
    </div>
    <div class="post-list">
        <?php if (empty($posts)): ?>
            <div style="padding: 40px; text-align: center; color: #666;">
                <i class="fas fa-inbox" style="font-size: 48px; margin-bottom: 15px;"></i>
                <p>该板块还没有帖子，快来发布第一个帖子吧！</p>
            </div>
        <?php else: ?>
            <?php foreach ($posts as $post): ?>
                <div class="post-item" onclick="location.href='post.php?id=<?php echo $post['id']; ?>'" style="cursor: pointer;">
                    <div class="post-avatar" onclick="event.stopPropagation();">
                        <div class="avatar">
                            <?php if ($post['avatar']): ?>
                                <img src="<?php echo e($post['avatar']); ?>" alt="<?php echo e($post['username']); ?>">
                            <?php else: ?>
                                <i class="fas fa-user"></i>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="post-content">
                        <div class="post-title">
                            <?php if ($post['is_top']): ?>
                                <span class="tag tag-top">置顶</span>
                            <?php endif; ?>
                            <?php if ($post['is_essence']): ?>
                                <span class="tag tag-essence">精华</span>
                            <?php endif; ?>
                            <span style="color: #333;"><?php echo e($post['title']); ?></span>
                        </div>
                        <div class="post-meta">
                            <a href="user.php?id=<?php echo $post['user_id']; ?>" onclick="event.stopPropagation();"><?php echo e($post['username']); ?></a>
                            <span>•</span>
                            <span><?php echo formatTime($post['created_at']); ?></span>
                            <?php if ($post['last_reply_at']): ?>
                                <span>•</span>
                                <span>最后回复 <?php echo formatTime($post['last_reply_at']); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="post-stats">
                        <div class="stat-item">
                            <div class="stat-value"><?php echo $post['view_count']; ?></div>
                            <div class="stat-label">浏览</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value"><?php echo $post['reply_count']; ?></div>
                            <div class="stat-label">回复</div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<?php if ($total > $perPage): ?>
    <?php echo pagination($total, $page, $perPage, 'category.php?id=' . $categoryId); ?>
<?php endif; ?>

    <?php
    include __DIR__ . '/templates/footer.php';
}
?>