<?php
/**
 * 论坛首页
 */
require_once __DIR__ . '/includes/functions.php';

// 检测是否为移动设备，如果是则跳转到手机版
function isMobile() {
    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    $mobileAgents = ['Mobile', 'Android', 'iPhone', 'iPad', 'iPod', 'Windows Phone', 'webOS', 'BlackBerry'];
    foreach ($mobileAgents as $agent) {
        if (stripos($userAgent, $agent) !== false) {
            return true;
        }
    }
    return false;
}

// 如果用户使用手机访问且没有强制使用PC版，则跳转到手机版
if (isMobile() && !isset($_GET['pc'])) {
    header('Location: ' . SITE_URL . '/mobile/index.php');
    exit;
}

// 获取板块列表
$categories = db()->query(
    "SELECT c.*, COUNT(DISTINCT p.id) as post_count 
     FROM categories c 
     LEFT JOIN posts p ON c.id = p.category_id AND p.status = 1 
     WHERE c.status = 1 
     GROUP BY c.id 
     ORDER BY c.sort_order ASC"
);

// 获取最新帖子（置顶帖优先）
$latestPosts = db()->query(
    "SELECT p.*, u.username, u.avatar, c.name as category_name 
     FROM posts p 
     LEFT JOIN users u ON p.user_id = u.id 
     LEFT JOIN categories c ON p.category_id = c.id 
     WHERE p.status = 1 
     ORDER BY p.is_top DESC, p.created_at DESC 
     LIMIT 10"
);

$pageTitle = '首页';
include __DIR__ . '/templates/header.php';
?>

<div class="section">
    <div class="card">
        <div class="card-header">
            <h2><i class="fas fa-th-large"></i> 板块列表</h2>
        </div>
        <div class="card-body">
            <div class="category-list">
                <?php foreach ($categories as $category): ?>
                    <a href="category.php?id=<?php echo $category['id']; ?>" class="category-card">
                        <div class="category-icon">
                            <i class="fas <?php echo e($category['icon'] ?: 'fa-folder'); ?>"></i>
                        </div>
                        <h3><?php echo e($category['name']); ?></h3>
                        <p><?php echo e($category['description']); ?></p>
                        <div class="category-meta">
                            <span><i class="fas fa-file-alt"></i> <?php echo $category['post_count']; ?> 帖子</span>
                            <span><i class="fas fa-arrow-right"></i></span>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

<div class="section" style="margin-top: 30px;">
    <div class="card">
        <div class="card-header">
            <h2><i class="fas fa-clock"></i> 最新帖子</h2>
            <?php if (isLoggedIn()): ?>
                <a href="create-post.php" class="btn btn-primary">
                    <i class="fas fa-plus"></i> 发帖
                </a>
            <?php endif; ?>
        </div>
        <div class="post-list">
            <?php if (empty($latestPosts)): ?>
                <div style="padding: 40px; text-align: center; color: #666;">
                    <i class="fas fa-inbox" style="font-size: 48px; margin-bottom: 15px;"></i>
                    <p>还没有帖子，快来发布第一个帖子吧！</p>
                </div>
            <?php else: ?>
                <?php foreach ($latestPosts as $post): ?>
                    <div class="post-item" onclick="location.href='post.php?id=<?php echo $post['id']; ?>'" style="cursor: pointer;">
                        <div class="post-avatar" onclick="event.stopPropagation();">
                            <div class="avatar">
                                <?php if ($post['avatar']): ?>
                                    <img src="<?php echo e($post['avatar']); ?>" alt="<?php echo e($post['username']); ?>">
                                <?php else: ?>
                                    <i class="fas fa-user"></i>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="post-content">
                            <div class="post-title">
                                <?php if ($post['is_top']): ?>
                                    <span class="tag tag-top">置顶</span>
                                <?php endif; ?>
                                <?php if ($post['is_essence']): ?>
                                    <span class="tag tag-essence">精华</span>
                                <?php endif; ?>
                                <span style="color: #333;"><?php echo e($post['title']); ?></span>
                            </div>
                            <div class="post-meta">
                                <a href="user.php?id=<?php echo $post['user_id']; ?>" onclick="event.stopPropagation();"><?php echo e($post['username']); ?></a>
                                <span>•</span>
                                <a href="category.php?id=<?php echo $post['category_id']; ?>" onclick="event.stopPropagation();"><?php echo e($post['category_name']); ?></a>
                                <span>•</span>
                                <span><?php echo formatTime($post['created_at']); ?></span>
                            </div>
                        </div>
                        <div class="post-stats">
                            <div class="stat-item">
                                <div class="stat-value"><?php echo $post['view_count']; ?></div>
                                <div class="stat-label">浏览</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-value"><?php echo $post['reply_count']; ?></div>
                                <div class="stat-label">回复</div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include __DIR__ . '/templates/footer.php'; ?>
