<?php
require_once __DIR__ . '/../includes/functions.php';

$categoryId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($categoryId <= 0) {
    header('Location: ' . SITE_URL . '/mobile/category.php');
    exit;
}

$db = Database::getInstance();

// 获取板块信息
$category = $db->queryOne("SELECT * FROM categories WHERE id = ? AND status = 1", [$categoryId]);

if (!$category) {
    header('Location: ' . SITE_URL . '/mobile/category.php');
    exit;
}

// 获取该板块的帖子
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page = max(1, $page);
$perPage = 20;
$offset = ($page - 1) * $perPage;

$posts = $db->query(
    "SELECT p.*, u.username, u.avatar 
     FROM posts p 
     LEFT JOIN users u ON p.user_id = u.id 
     WHERE p.category_id = ? AND p.status = 1 
     ORDER BY p.is_top DESC, p.created_at DESC 
     LIMIT ? OFFSET ?",
    [$categoryId, $perPage, $offset]
);

// 获取总帖子数
$totalResult = $db->queryOne("SELECT COUNT(*) as total FROM posts WHERE category_id = ? AND status = 1", [$categoryId]);
$totalPosts = $totalResult ? $totalResult['total'] : 0;
$totalPages = ceil($totalPosts / $perPage);

$pageTitle = $category['name'];
include __DIR__ . '/includes/header.php';
?>

<div class="mobile-section">
    <div class="mobile-section-title">
        <i class="fas <?php echo $category['icon'] ? e($category['icon']) : 'fa-folder'; ?>" style="color: var(--primary-color);"></i>
        <span><?php echo e($category['name']); ?></span>
        <span style="margin-left: auto; font-size: 12px; color: #999;"><?php echo $totalPosts; ?> 帖子</span>
    </div>
    
    <?php if (empty($posts)): ?>
    <div class="mobile-empty">
        <i class="fas fa-inbox"></i>
        <p>该板块暂无帖子</p>
        <a href="<?php echo SITE_URL; ?>/mobile/create-post.php" class="mobile-btn mobile-btn-primary" style="margin-top: 15px;">
            <i class="fas fa-plus"></i> 发布第一个帖子
        </a>
    </div>
    <?php else: ?>
    <div class="mobile-post-list">
        <?php foreach ($posts as $post): ?>
        <a href="<?php echo SITE_URL; ?>/mobile/post.php?id=<?php echo $post['id']; ?>" class="mobile-post-item <?php echo $post['is_top'] ? 'pinned' : ''; ?>">
            <div class="mobile-post-title">
                <?php if ($post['is_top']): ?>
                <i class="fas fa-thumbtack" style="color: #f59e0b; margin-right: 5px;"></i>
                <?php endif; ?>
                <?php echo e($post['title']); ?>
            </div>
            <div class="mobile-post-meta">
                <span><?php echo e($post['username']); ?></span>
                <span><i class="fas fa-eye"></i> <?php echo $post['view_count']; ?></span>
                <span><i class="fas fa-comment"></i> <?php echo $post['reply_count']; ?></span>
                <span><?php echo formatTime($post['created_at']); ?></span>
            </div>
        </a>
        <?php endforeach; ?>
    </div>
    
    <!-- 分页 -->
    <?php if ($totalPages > 1): ?>
    <div class="mobile-pagination">
        <?php if ($page > 1): ?>
        <a href="?id=<?php echo $categoryId; ?>&page=<?php echo $page - 1; ?>" class="mobile-page-btn">
            <i class="fas fa-chevron-left"></i> 上一页
        </a>
        <?php endif; ?>
        <span class="mobile-page-info"><?php echo $page; ?> / <?php echo $totalPages; ?></span>
        <?php if ($page < $totalPages): ?>
        <a href="?id=<?php echo $categoryId; ?>&page=<?php echo $page + 1; ?>" class="mobile-page-btn">
            下一页 <i class="fas fa-chevron-right"></i>
        </a>
        <?php endif; ?>
    </div>
    <?php endif; ?>
    <?php endif; ?>
</div>

<style>
.mobile-empty {
    text-align: center;
    padding: 60px 20px;
    color: #999;
}
.mobile-empty i {
    font-size: 48px;
    margin-bottom: 15px;
    color: #ddd;
}
.mobile-pagination {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 15px;
    padding: 15px;
    border-top: 1px solid #f0f0f0;
}
.mobile-page-btn {
    padding: 8px 15px;
    background: var(--primary-color);
    color: #fff;
    border-radius: 6px;
    font-size: 13px;
}
.mobile-page-info {
    font-size: 14px;
    color: #666;
}
</style>

<?php include __DIR__ . '/includes/footer.php'; ?>
