<?php
require_once __DIR__ . '/../includes/functions.php';

$db = Database::getInstance();

// 获取所有板块
$categories = $db->query(
    "SELECT c.*, COUNT(DISTINCT p.id) as post_count 
     FROM categories c 
     LEFT JOIN posts p ON c.id = p.category_id AND p.status = 1 
     WHERE c.status = 1 
     GROUP BY c.id 
     ORDER BY c.sort_order ASC"
);

$pageTitle = '板块列表';
include __DIR__ . '/includes/header.php';
?>

<div class="mobile-section">
    <div class="mobile-section-title">
        <i class="fas fa-th-large" style="color: var(--primary-color);"></i>
        <span>所有板块</span>
    </div>
    <div class="mobile-category-list">
        <?php foreach ($categories as $category): ?>
        <a href="<?php echo SITE_URL; ?>/mobile/category-view.php?id=<?php echo $category['id']; ?>" class="mobile-category-item">
            <div class="mobile-category-icon">
                <?php if ($category['icon']): ?>
                    <i class="fas <?php echo e($category['icon']); ?>"></i>
                <?php else: ?>
                    <i class="fas fa-folder"></i>
                <?php endif; ?>
            </div>
            <div class="mobile-category-info">
                <div class="mobile-category-name"><?php echo e($category['name']); ?></div>
                <div class="mobile-category-desc"><?php echo e($category['description']); ?></div>
                <div class="mobile-category-meta">
                    <span><i class="fas fa-file-alt"></i> <?php echo $category['post_count']; ?> 帖子</span>
                </div>
            </div>
            <i class="fas fa-chevron-right" style="color: #ccc;"></i>
        </a>
        <?php endforeach; ?>
    </div>
</div>

<style>
.mobile-category-list {
    display: flex;
    flex-direction: column;
}
.mobile-category-item {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 15px;
    border-bottom: 1px solid #f0f0f0;
}
.mobile-category-item:last-child {
    border-bottom: none;
}
.mobile-category-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    background: var(--primary-color);
    color: #fff;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    flex-shrink: 0;
}
.mobile-category-info {
    flex: 1;
}
.mobile-category-name {
    font-size: 16px;
    font-weight: 500;
    color: #333;
    margin-bottom: 4px;
}
.mobile-category-desc {
    font-size: 13px;
    color: #999;
    margin-bottom: 6px;
    display: -webkit-box;
    -webkit-line-clamp: 1;
    -webkit-box-orient: vertical;
    overflow: hidden;
}
.mobile-category-meta {
    font-size: 12px;
    color: #999;
}
</style>

<?php include __DIR__ . '/includes/footer.php'; ?>
