<?php
require_once __DIR__ . '/../includes/functions.php';

$currentUser = getCurrentUser();

// 如果没有登录，跳转到登录页
if (!$currentUser) {
    header('Location: ' . SITE_URL . '/mobile/login.php');
    exit;
}

$db = Database::getInstance();

// 获取所有板块
$categories = $db->query("SELECT * FROM categories WHERE status = 1 ORDER BY sort_order ASC");

$error = '';
$success = '';

// 处理表单提交
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $categoryId = (int)($_POST['category_id'] ?? 0);
    $title = trim($_POST['title'] ?? '');
    $content = trim($_POST['content'] ?? '');
    
    if ($categoryId <= 0) {
        $error = '请选择板块';
    } elseif (empty($title)) {
        $error = '请输入标题';
    } elseif (mb_strlen($title) > 200) {
        $error = '标题不能超过200字';
    } elseif (empty($content)) {
        $error = '请输入内容';
    } else {
        // 创建帖子
        $postId = $db->insert(
            "INSERT INTO posts (user_id, category_id, title, content, status, created_at) VALUES (?, ?, ?, ?, 1, NOW())",
            [$currentUser['id'], $categoryId, $title, $content]
        );
        
        // 更新用户发帖数
        $db->query("UPDATE users SET post_count = post_count + 1 WHERE id = ?", [$currentUser['id']]);
        
        // 更新板块帖子数
        $db->query("UPDATE categories SET post_count = post_count + 1 WHERE id = ?", [$categoryId]);
        
        $success = '发布成功';
        header('Location: ' . SITE_URL . '/mobile/post.php?id=' . $postId);
        exit;
    }
}

$pageTitle = '发布帖子';
include __DIR__ . '/includes/header.php';
?>

<div class="mobile-section">
    <div class="mobile-section-title">
        <i class="fas fa-edit" style="color: var(--primary-color);"></i>
        <span>发布新帖</span>
    </div>
    
    <?php if ($error): ?>
    <div class="mobile-alert mobile-alert-error">
        <?php echo e($error); ?>
    </div>
    <?php endif; ?>
    
    <form method="POST" action="" class="mobile-form">
        <div class="mobile-form-group">
            <label>选择板块</label>
            <select name="category_id" class="mobile-form-control" required>
                <option value="">请选择板块</option>
                <?php foreach ($categories as $category): ?>
                <option value="<?php echo $category['id']; ?>"><?php echo e($category['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="mobile-form-group">
            <label>标题</label>
            <input type="text" name="title" class="mobile-form-control" placeholder="请输入标题" maxlength="200" required>
        </div>
        
        <div class="mobile-form-group">
            <label>内容</label>
            <textarea name="content" class="mobile-form-control" rows="10" placeholder="请输入内容" required></textarea>
        </div>
        
        <button type="submit" class="mobile-btn mobile-btn-primary mobile-btn-block">
            <i class="fas fa-paper-plane"></i> 发布帖子
        </button>
    </form>
</div>

<style>
.mobile-alert {
    padding: 12px 15px;
    margin: 15px;
    border-radius: 8px;
    font-size: 14px;
}
.mobile-alert-error {
    background: #ffebee;
    color: #c62828;
}
.mobile-form {
    padding: 15px;
}
.mobile-form-group {
    margin-bottom: 15px;
}
.mobile-form-group label {
    display: block;
    font-size: 14px;
    color: #333;
    margin-bottom: 8px;
    font-weight: 500;
}
.mobile-form-control {
    width: 100%;
    padding: 12px;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    font-size: 15px;
    background: #fff;
}
.mobile-form-control:focus {
    outline: none;
    border-color: var(--primary-color);
}
select.mobile-form-control {
    height: 44px;
}
textarea.mobile-form-control {
    resize: vertical;
    min-height: 150px;
}
.mobile-btn {
    padding: 12px 20px;
    border: none;
    border-radius: 8px;
    font-size: 15px;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}
.mobile-btn-primary {
    background: var(--primary-color);
    color: #fff;
}
.mobile-btn-block {
    width: 100%;
}
</style>

<?php include __DIR__ . '/includes/footer.php'; ?>
