<?php
// 获取未读消息数量
$unreadCount = $currentUser ? getUnreadNotificationCount($currentUser['id']) : 0;

// 获取当前页面
$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>
    </main>

    <!-- 手机版底部导航栏 -->
    <nav class="mobile-bottom-nav">
        <a href="<?php echo SITE_URL; ?>/mobile/index.php" class="mobile-nav-item <?php echo $currentPage == 'index' ? 'active' : ''; ?>">
            <i class="fas fa-home"></i>
            <span>首页</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/mobile/category.php" class="mobile-nav-item <?php echo $currentPage == 'category' ? 'active' : ''; ?>">
            <i class="fas fa-th-large"></i>
            <span>板块</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/mobile/create-post.php" class="mobile-nav-item mobile-nav-publish">
            <div class="publish-btn">
                <i class="fas fa-plus"></i>
            </div>
        </a>
        <a href="<?php echo SITE_URL; ?>/mobile/notifications.php" class="mobile-nav-item <?php echo $currentPage == 'notifications' ? 'active' : ''; ?>">
            <i class="fas fa-bell"></i>
            <?php if ($unreadCount > 0): ?>
                <span class="nav-badge"><?php echo $unreadCount > 99 ? '99+' : $unreadCount; ?></span>
            <?php endif; ?>
            <span>消息</span>
        </a>
        <?php if ($currentUser): ?>
            <a href="<?php echo SITE_URL; ?>/mobile/user.php?id=<?php echo $currentUser['id']; ?>" class="mobile-nav-item <?php echo $currentPage == 'user' ? 'active' : ''; ?>">
                <?php if ($currentUser['avatar']): ?>
                    <img src="<?php echo strpos($currentUser['avatar'], 'http') === 0 ? e($currentUser['avatar']) : SITE_URL . '/' . ltrim(e($currentUser['avatar']), '/'); ?>" alt="" class="nav-avatar">
                <?php else: ?>
                    <i class="fas fa-user"></i>
                <?php endif; ?>
                <span>我的</span>
            </a>
        <?php else: ?>
            <a href="<?php echo SITE_URL; ?>/mobile/login.php" class="mobile-nav-item <?php echo $currentPage == 'login' ? 'active' : ''; ?>">
                <i class="fas fa-user"></i>
                <span>我的</span>
            </a>
        <?php endif; ?>
    </nav>

</body>
</html>
