<?php
require_once __DIR__ . '/../../includes/functions.php';

// 使用不同的变量名避免覆盖页面中的 $user 变量
$currentUser = getCurrentUser();
$siteName = getSetting('site_name', SITE_NAME);

// 检测是否为手机版访问
$isMobile = true;

// 获取当前页面名称
$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?php echo isset($pageTitle) ? e($pageTitle) . ' - ' : ''; ?><?php echo e($siteName); ?></title>
    <meta name="description" content="<?php echo e(getSetting('site_description', '一个简洁优雅的PHP论坛系统')); ?>">
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/mobile/css/mobile.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="mobile-body">
    <!-- 手机版头部 -->
    <header class="mobile-header">
        <div class="mobile-header-inner">
            <!-- 左侧Logo/标题 -->
            <a href="<?php echo SITE_URL; ?>/mobile/index.php" class="mobile-logo">
                <i class="fas fa-comments"></i>
                <span><?php echo e($siteName); ?></span>
            </a>
            
            <!-- 右侧搜索按钮 -->
            <a href="<?php echo SITE_URL; ?>/mobile/search.php" class="mobile-header-search-btn">
                <i class="fas fa-search"></i>
            </a>
        </div>
    </header>

    <!-- 主内容区 -->
    <main class="mobile-main">
