<?php
require_once __DIR__ . '/../includes/functions.php';

$db = Database::getInstance();

// 获取置顶帖子
$pinnedPosts = $db->query(
    "SELECT p.*, u.username, u.avatar, c.name as category_name 
     FROM posts p 
     LEFT JOIN users u ON p.user_id = u.id 
     LEFT JOIN categories c ON p.category_id = c.id 
     WHERE p.status = 1 AND p.is_top = 1 
     ORDER BY p.created_at DESC LIMIT 5"
);

// 获取最新帖子
$latestPosts = $db->query(
    "SELECT p.*, u.username, u.avatar, c.name as category_name 
     FROM posts p 
     LEFT JOIN users u ON p.user_id = u.id 
     LEFT JOIN categories c ON p.category_id = c.id 
     WHERE p.status = 1 
     ORDER BY p.created_at DESC LIMIT 20"
);

$pageTitle = '首页';
include __DIR__ . '/includes/header.php';
?>

<!-- 置顶帖子 -->
<?php if (!empty($pinnedPosts)): ?>
<div class="mobile-section">
    <div class="mobile-section-title">
        <i class="fas fa-thumbtack" style="color: #f59e0b;"></i>
        <span>置顶帖子</span>
    </div>
    <div class="mobile-post-list">
        <?php foreach ($pinnedPosts as $post): ?>
        <a href="<?php echo SITE_URL; ?>/mobile/post.php?id=<?php echo $post['id']; ?>" class="mobile-post-item pinned">
            <div class="mobile-post-title"><?php echo e($post['title']); ?></div>
            <div class="mobile-post-meta">
                <?php if ($post['category_name']): ?>
                <span class="mobile-post-category"><?php echo e($post['category_name']); ?></span>
                <?php endif; ?>
                <span><?php echo e($post['username']); ?></span>
                <span><i class="fas fa-eye"></i> <?php echo $post['view_count']; ?></span>
                <span><i class="fas fa-comment"></i> <?php echo $post['reply_count']; ?></span>
            </div>
        </a>
        <?php endforeach; ?>
    </div>
</div>
<?php endif; ?>

<!-- 最新帖子 -->
<div class="mobile-section">
    <div class="mobile-section-title">
        <i class="fas fa-clock" style="color: var(--primary-color);"></i>
        <span>最新帖子</span>
    </div>
    <div class="mobile-post-list">
        <?php foreach ($latestPosts as $post): ?>
        <a href="<?php echo SITE_URL; ?>/mobile/post.php?id=<?php echo $post['id']; ?>" class="mobile-post-item">
            <div class="mobile-post-title"><?php echo e($post['title']); ?></div>
            <div class="mobile-post-meta">
                <?php if ($post['category_name']): ?>
                <span class="mobile-post-category"><?php echo e($post['category_name']); ?></span>
                <?php endif; ?>
                <span><?php echo e($post['username']); ?></span>
                <span><i class="fas fa-eye"></i> <?php echo $post['view_count']; ?></span>
                <span><i class="fas fa-comment"></i> <?php echo $post['reply_count']; ?></span>
            </div>
        </a>
        <?php endforeach; ?>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
