<?php
require_once __DIR__ . '/../includes/functions.php';

// 如果已登录，跳转到首页
if (getCurrentUser()) {
    header('Location: ' . SITE_URL . '/mobile/index.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $remember = isset($_POST['remember']);
    
    if (empty($username) || empty($password)) {
        $error = '请输入用户名和密码';
    } else {
        $db = Database::getInstance();
        
        // 检查用户名或邮箱
        $user = $db->queryOne(
            "SELECT * FROM users WHERE username = ? OR email = ?",
            [$username, $username]
        );
        
        if (!$user) {
            $error = '用户名或密码错误';
        } elseif (!password_verify($password, $user['password'])) {
            $error = '用户名或密码错误';
        } elseif ($user['status'] == 0) {
            $error = '您的账号已被禁用';
        } else {
            // 登录成功
            $_SESSION['user_id'] = $user['id'];
            
            // 记住我
            if ($remember) {
                $token = bin2hex(random_bytes(32));
                setcookie('remember_token', $token, time() + 30 * 24 * 3600, '/', '', false, true);
                $db->query("UPDATE users SET remember_token = ? WHERE id = ?", [$token, $user['id']]);
            }
            
            // 更新最后登录时间
            $db->query("UPDATE users SET last_login = NOW() WHERE id = ?", [$user['id']]);
            
            header('Location: ' . SITE_URL . '/mobile/index.php');
            exit;
        }
    }
}

$pageTitle = '登录';
include __DIR__ . '/includes/header.php';
?>

<div class="mobile-auth-container">
    <div class="mobile-auth-logo">
        <i class="fas fa-comments"></i>
        <h1><?php echo e(getSetting('site_name', SITE_NAME)); ?></h1>
    </div>
    
    <?php if ($error): ?>
    <div class="mobile-alert mobile-alert-error">
        <?php echo e($error); ?>
    </div>
    <?php endif; ?>
    
    <form method="POST" action="" class="mobile-auth-form">
        <div class="mobile-form-group">
            <label>用户名或邮箱</label>
            <input type="text" name="username" class="mobile-form-control" placeholder="请输入用户名或邮箱" required>
        </div>
        
        <div class="mobile-form-group">
            <label>密码</label>
            <input type="password" name="password" class="mobile-form-control" placeholder="请输入密码" required>
        </div>
        
        <div class="mobile-form-group">
            <label class="mobile-checkbox">
                <input type="checkbox" name="remember" value="1">
                <span>记住我</span>
            </label>
        </div>
        
        <button type="submit" class="mobile-btn mobile-btn-primary mobile-btn-block">
            <i class="fas fa-sign-in-alt"></i> 登录
        </button>
    </form>
    
    <div class="mobile-auth-footer">
        还没有账号？<a href="<?php echo SITE_URL; ?>/mobile/register.php">立即注册</a>
    </div>
</div>

<style>
.mobile-auth-container {
    padding: 30px 20px;
}
.mobile-auth-logo {
    text-align: center;
    margin-bottom: 30px;
}
.mobile-auth-logo i {
    font-size: 60px;
    color: var(--primary-color);
    margin-bottom: 15px;
}
.mobile-auth-logo h1 {
    font-size: 24px;
    color: #333;
}
.mobile-alert {
    padding: 12px 15px;
    margin-bottom: 20px;
    border-radius: 8px;
    font-size: 14px;
}
.mobile-alert-error {
    background: #ffebee;
    color: #c62828;
}
.mobile-auth-form {
    background: #fff;
    padding: 20px;
    border-radius: 12px;
    margin-bottom: 20px;
}
.mobile-form-group {
    margin-bottom: 15px;
}
.mobile-form-group label {
    display: block;
    font-size: 14px;
    color: #333;
    margin-bottom: 8px;
    font-weight: 500;
}
.mobile-form-control {
    width: 100%;
    padding: 12px 15px;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    font-size: 15px;
}
.mobile-checkbox {
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    color: #666;
    cursor: pointer;
}
.mobile-checkbox input {
    width: 18px;
    height: 18px;
}
.mobile-btn {
    padding: 12px 20px;
    border: none;
    border-radius: 8px;
    font-size: 15px;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}
.mobile-btn-primary {
    background: var(--primary-color);
    color: #fff;
}
.mobile-btn-block {
    width: 100%;
}
.mobile-auth-footer {
    text-align: center;
    font-size: 14px;
    color: #666;
}
.mobile-auth-footer a {
    color: var(--primary-color);
    font-weight: 500;
}
</style>

<?php include __DIR__ . '/includes/footer.php'; ?>
