<?php
require_once __DIR__ . '/../includes/functions.php';

$keyword = isset($_GET['q']) ? trim($_GET['q']) : '';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page = max(1, $page);
$perPage = 20;

$posts = [];
$totalResults = 0;
$totalPages = 0;

if ($keyword) {
    $db = Database::getInstance();
    $offset = ($page - 1) * $perPage;
    $searchTerm = '%' . $keyword . '%';
    
    $countSql = "SELECT COUNT(*) as total FROM posts WHERE status = 1 AND (title LIKE ? OR content LIKE ?)";
    $countResult = $db->queryOne($countSql, [$searchTerm, $searchTerm]);
    $totalResults = $countResult ? $countResult['total'] : 0;
    $totalPages = ceil($totalResults / $perPage);
    
    $sql = "SELECT p.*, c.name as category_name, u.username, u.avatar 
            FROM posts p 
            LEFT JOIN categories c ON p.category_id = c.id 
            LEFT JOIN users u ON p.user_id = u.id 
            WHERE p.status = 1 AND (p.title LIKE ? OR p.content LIKE ?)
            ORDER BY p.is_top DESC, p.created_at DESC 
            LIMIT ? OFFSET ?";
    $result = $db->query($sql, [$searchTerm, $searchTerm, $perPage, $offset]);
    $posts = $result === false ? [] : $result;
}

$pageTitle = $keyword ? '搜索: ' . $keyword : '搜索';
include __DIR__ . '/includes/header.php';
?>

<div class="mobile-search-box">
    <form action="<?php echo SITE_URL; ?>/mobile/search.php" method="get" class="mobile-search-form">
        <input type="text" name="q" class="mobile-search-input" placeholder="搜索帖子..." value="<?php echo e($keyword); ?>" required>
        <button type="submit" class="mobile-search-btn">
            <i class="fas fa-search"></i>
        </button>
    </form>
</div>

<?php if ($keyword): ?>
<div class="mobile-section">
    <div class="mobile-section-title">
        <i class="fas fa-search" style="color: var(--primary-color);"></i>
        <span>找到 <?php echo $totalResults; ?> 条结果</span>
    </div>
    
    <?php if (empty($posts)): ?>
    <div class="mobile-empty">
        <i class="fas fa-search"></i>
        <p>未找到相关结果</p>
    </div>
    <?php else: ?>
    <div class="mobile-post-list">
        <?php foreach ($posts as $post): ?>
        <a href="<?php echo SITE_URL; ?>/mobile/post.php?id=<?php echo $post['id']; ?>" class="mobile-post-item">
            <div class="mobile-post-title">
                <?php echo highlightKeyword(e($post['title']), $keyword); ?>
            </div>
            <div class="mobile-post-meta">
                <?php if ($post['category_name']): ?>
                <span class="mobile-post-category"><?php echo e($post['category_name']); ?></span>
                <?php endif; ?>
                <span><?php echo e($post['username']); ?></span>
                <span><i class="fas fa-eye"></i> <?php echo $post['view_count']; ?></span>
                <span><i class="fas fa-comment"></i> <?php echo $post['reply_count']; ?></span>
            </div>
        </a>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</div>
<?php endif; ?>

<style>
.mobile-search-box {
    background: #fff;
    padding: 15px;
    margin-bottom: 10px;
}
.mobile-search-form {
    display: flex;
    gap: 10px;
}
.mobile-search-input {
    flex: 1;
    padding: 12px 15px;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    font-size: 15px;
}
.mobile-search-btn {
    padding: 12px 20px;
    background: var(--primary-color);
    color: #fff;
    border: none;
    border-radius: 8px;
    font-size: 16px;
}
.mobile-empty {
    text-align: center;
    padding: 60px 20px;
    color: #999;
}
.mobile-empty i {
    font-size: 48px;
    margin-bottom: 15px;
    color: #ddd;
}
</style>

<?php
function highlightKeyword($text, $keyword) {
    if (empty($keyword)) return $text;
    $keyword = preg_quote($keyword, '/');
    return preg_replace('/(' . $keyword . ')/i', '<mark style="background: #fef08a; padding: 0 2px;">$1</mark>', $text);
}

include __DIR__ . '/includes/footer.php';
?>
