<?php
require_once __DIR__ . '/../includes/functions.php';

$userId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($userId <= 0) {
    header('Location: ' . SITE_URL . '/mobile/index.php');
    exit;
}

$db = Database::getInstance();

// 获取用户信息
$user = $db->queryOne("SELECT * FROM users WHERE id = ?", [$userId]);

if (!$user) {
    header('Location: ' . SITE_URL . '/mobile/index.php');
    exit;
}

// 获取用户的帖子
$posts = $db->query(
    "SELECT p.*, c.name as category_name 
     FROM posts p 
     LEFT JOIN categories c ON p.category_id = c.id 
     WHERE p.user_id = ? AND p.status = 1 
     ORDER BY p.created_at DESC",
    [$userId]
);

$pageTitle = $user['username'] . '的帖子';
include __DIR__ . '/includes/header.php';
?>

<div class="mobile-section">
    <div class="mobile-section-title">
        <i class="fas fa-user" style="color: var(--primary-color);"></i>
        <span><?php echo e($user['username']); ?> 的帖子</span>
    </div>
    
    <?php if (empty($posts)): ?>
    <div class="mobile-empty">
        <i class="fas fa-file-alt"></i>
        <p>暂无帖子</p>
    </div>
    <?php else: ?>
    <div class="mobile-post-list">
        <?php foreach ($posts as $post): ?>
        <a href="<?php echo SITE_URL; ?>/mobile/post.php?id=<?php echo $post['id']; ?>" class="mobile-post-item">
            <div class="mobile-post-title"><?php echo e($post['title']); ?></div>
            <div class="mobile-post-meta">
                <?php if ($post['category_name']): ?>
                <span class="mobile-post-category"><?php echo e($post['category_name']); ?></span>
                <?php endif; ?>
                <span><i class="fas fa-eye"></i> <?php echo $post['view_count']; ?></span>
                <span><i class="fas fa-comment"></i> <?php echo $post['reply_count']; ?></span>
                <span><?php echo formatTime($post['created_at']); ?></span>
            </div>
        </a>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</div>

<style>
.mobile-empty {
    text-align: center;
    padding: 60px 20px;
    color: #999;
}
.mobile-empty i {
    font-size: 48px;
    margin-bottom: 15px;
    color: #ddd;
}
</style>

<?php include __DIR__ . '/includes/footer.php'; ?>
