<?php
require_once __DIR__ . '/../includes/functions.php';

$userId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($userId <= 0) {
    header('Location: ' . SITE_URL . '/mobile/index.php');
    exit;
}

$db = Database::getInstance();

// 获取用户信息
$user = $db->queryOne("SELECT * FROM users WHERE id = ?", [$userId]);

if (!$user) {
    header('Location: ' . SITE_URL . '/mobile/index.php');
    exit;
}

// 获取用户的回复
$replies = $db->query(
    "SELECT r.*, p.title as post_title, p.id as post_id 
     FROM replies r 
     LEFT JOIN posts p ON r.post_id = p.id 
     WHERE r.user_id = ? AND r.status = 1 AND p.status = 1 
     ORDER BY r.created_at DESC",
    [$userId]
);

$pageTitle = $user['username'] . '的回复';
include __DIR__ . '/includes/header.php';
?>

<div class="mobile-section">
    <div class="mobile-section-title">
        <i class="fas fa-user" style="color: var(--primary-color);"></i>
        <span><?php echo e($user['username']); ?> 的回复</span>
    </div>
    
    <?php if (empty($replies)): ?>
    <div class="mobile-empty">
        <i class="fas fa-comment"></i>
        <p>暂无回复</p>
    </div>
    <?php else: ?>
    <div class="mobile-reply-list">
        <?php foreach ($replies as $reply): ?>
        <a href="<?php echo SITE_URL; ?>/mobile/post.php?id=<?php echo $reply['post_id']; ?>" class="mobile-reply-item">
            <div class="mobile-reply-post"><?php echo e($reply['post_title']); ?></div>
            <div class="mobile-reply-content"><?php echo e(strip_tags($reply['content'])); ?></div>
            <div class="mobile-reply-time"><?php echo formatTime($reply['created_at']); ?></div>
        </a>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</div>

<style>
.mobile-empty {
    text-align: center;
    padding: 60px 20px;
    color: #999;
}
.mobile-empty i {
    font-size: 48px;
    margin-bottom: 15px;
    color: #ddd;
}
.mobile-reply-list {
    display: flex;
    flex-direction: column;
}
.mobile-reply-item {
    padding: 15px;
    border-bottom: 1px solid #f0f0f0;
    display: block;
}
.mobile-reply-item:last-child {
    border-bottom: none;
}
.mobile-reply-post {
    font-size: 14px;
    font-weight: 500;
    color: var(--primary-color);
    margin-bottom: 8px;
}
.mobile-reply-content {
    font-size: 14px;
    color: #333;
    line-height: 1.5;
    margin-bottom: 8px;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}
.mobile-reply-time {
    font-size: 12px;
    color: #999;
}
</style>

<?php include __DIR__ . '/includes/footer.php'; ?>
