<?php
require_once __DIR__ . '/../includes/functions.php';

// 获取当前登录用户
$currentUser = getCurrentUser();

// 获取要查看的用户ID（从URL参数）
$viewUserId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// 如果没有指定用户ID，且当前用户已登录，则显示当前用户
if ($viewUserId <= 0 && $currentUser) {
    $viewUserId = $currentUser['id'];
}

// 如果没有用户ID且未登录，跳转到登录页
if ($viewUserId <= 0) {
    header('Location: ' . SITE_URL . '/mobile/login.php');
    exit;
}

// 获取要查看的用户信息
$db = Database::getInstance();
$viewUser = $db->queryOne("SELECT * FROM users WHERE id = ?", [$viewUserId]);

// 如果用户不存在，跳转到首页
if (!$viewUser) {
    header('Location: ' . SITE_URL . '/mobile/index.php');
    exit;
}

// 获取用户勋章
$wearingMedals = getUserWearingMedals($viewUserId);

// 判断是否查看自己的主页
$isOwnProfile = $currentUser && $currentUser['id'] == $viewUserId;

$pageTitle = $viewUser['username'] . '的主页';
include __DIR__ . '/includes/header.php';
?>

<!-- 返回按钮 -->
<div class="mobile-back-bar">
    <a href="javascript:history.back();" class="mobile-back-btn">
        <i class="fas fa-arrow-left"></i> 返回
    </a>
</div>

<!-- 用户信息卡片 -->
<div class="mobile-user-card">
    <div class="mobile-user-avatar">
        <?php if (!empty($viewUser['avatar']) && $viewUser['avatar'] != 'NULL'): ?>
            <?php
            // 处理头像路径
            $avatarUrl = $viewUser['avatar'];
            if (!preg_match('/^https?:\/\//', $avatarUrl) && !preg_match('/^\//', $avatarUrl)) {
                $avatarUrl = SITE_URL . '/' . $avatarUrl;
            }
            ?>
            <img src="<?php echo e($avatarUrl); ?>?t=<?php echo time(); ?>" alt="<?php echo e($viewUser['username']); ?>" onerror="this.style.display='none'; this.parentElement.querySelector('.avatar-fallback').style.display='flex';">
            <i class="fas fa-user avatar-fallback" style="display: none;"></i>
        <?php else: ?>
            <i class="fas fa-user"></i>
        <?php endif; ?>
    </div>
    <div class="mobile-user-name">
        <?php echo e($viewUser['username']); ?>
        <?php if ($viewUser['role'] == 2): ?>
            <span class="mobile-user-badge" style="background: #e74c3c;">超管</span>
        <?php elseif ($viewUser['role'] == 1): ?>
            <span class="mobile-user-badge" style="background: var(--primary-color);">管理员</span>
        <?php endif; ?>
    </div>
    <?php if ($viewUser['signature']): ?>
    <div class="mobile-user-signature"><?php echo e($viewUser['signature']); ?></div>
    <?php endif; ?>
    
    <!-- 用户统计 -->
    <div class="mobile-user-stats">
        <a href="<?php echo SITE_URL; ?>/mobile/user-posts.php?id=<?php echo $viewUser['id']; ?>" class="mobile-user-stat">
            <div class="mobile-user-stat-value"><?php echo $viewUser['post_count']; ?></div>
            <div class="mobile-user-stat-label">帖子</div>
        </a>
        <a href="<?php echo SITE_URL; ?>/mobile/user-replies.php?id=<?php echo $viewUser['id']; ?>" class="mobile-user-stat">
            <div class="mobile-user-stat-value"><?php echo $viewUser['reply_count']; ?></div>
            <div class="mobile-user-stat-label">回复</div>
        </a>
        <div class="mobile-user-stat">
            <div class="mobile-user-stat-value"><?php echo formatTime($viewUser['created_at']); ?></div>
            <div class="mobile-user-stat-label">注册</div>
        </div>
    </div>
    
    <!-- 佩戴的勋章 -->
    <?php if (!empty($wearingMedals)): ?>
    <div class="mobile-user-medals">
        <?php foreach ($wearingMedals as $medal): ?>
        <span class="mobile-user-medal">
            <img src="<?php echo SITE_URL . '/' . $medal['icon']; ?>" alt="<?php echo e($medal['name']); ?>">
        </span>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
</div>

<?php if ($isOwnProfile): ?>
<!-- 功能菜单 - 仅在自己的主页显示 -->
<div class="mobile-menu-section">
    <div class="mobile-menu-title">我的功能</div>
    <div class="mobile-menu-grid">
        <a href="<?php echo SITE_URL; ?>/mobile/medals.php" class="mobile-menu-item">
            <div class="mobile-menu-icon" style="background: #fff3e0; color: #ff9800;">
                <i class="fas fa-medal"></i>
            </div>
            <span>我的勋章</span>
        </a>
        <a href="<?php echo SITE_URL; ?>/mobile/notifications.php" class="mobile-menu-item">
            <div class="mobile-menu-icon" style="background: #e3f2fd; color: #2196f3;">
                <i class="fas fa-bell"></i>
            </div>
            <span>消息通知</span>
            <?php 
            $menuUnreadCount = getUnreadNotificationCount($currentUser['id']);
            if ($menuUnreadCount > 0): 
            ?>
            <span class="mobile-menu-badge"><?php echo $menuUnreadCount > 99 ? '99+' : $menuUnreadCount; ?></span>
            <?php endif; ?>
        </a>
        <a href="<?php echo SITE_URL; ?>/mobile/settings.php" class="mobile-menu-item">
            <div class="mobile-menu-icon" style="background: #f3e5f5; color: #9c27b0;">
                <i class="fas fa-cog"></i>
            </div>
            <span>个人设置</span>
        </a>
        <?php if ($currentUser['role'] >= 1): ?>
        <a href="<?php echo SITE_URL; ?>/admin/" class="mobile-menu-item">
            <div class="mobile-menu-icon" style="background: #fce4ec; color: #e91e63;">
                <i class="fas fa-crown"></i>
            </div>
            <span>管理后台</span>
        </a>
        <?php endif; ?>
    </div>
</div>

<!-- 账号管理 -->
<div class="mobile-menu-section">
    <div class="mobile-menu-title">账号管理</div>
    <div class="mobile-menu-list">
        <a href="<?php echo SITE_URL; ?>/mobile/logout.php" class="mobile-menu-list-item">
            <i class="fas fa-sign-out-alt" style="color: #f44336;"></i>
            <span>退出登录</span>
            <i class="fas fa-chevron-right" style="margin-left: auto; color: #ccc;"></i>
        </a>
    </div>
</div>
<?php endif; ?>

<style>
.mobile-back-bar {
    background: #fff;
    padding: 10px 15px;
    border-bottom: 1px solid #f0f0f0;
}
.mobile-back-btn {
    display: inline-flex;
    align-items: center;
    gap: 5px;
    color: #666;
    font-size: 14px;
    text-decoration: none;
}
.mobile-back-btn i {
    font-size: 12px;
}
</style>

<?php include __DIR__ . '/includes/footer.php'; ?>
