<?php
/**
 * 消息通知页面 - 分类显示点赞、收藏、回复
 */
require_once __DIR__ . '/includes/functions.php';

// 检查是否登录
if (!isLoggedIn()) {
    redirect(SITE_URL . '/login.php');
}

$currentUser = getCurrentUser();
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$perPage = 20;

// 获取当前标签
$tab = isset($_GET['tab']) ? $_GET['tab'] : 'all';
if (!in_array($tab, ['all', 'like', 'favorite', 'reply'])) {
    $tab = 'all';
}

// 标记所有通知为已读
if (isset($_GET['mark_all_read'])) {
    markAllNotificationsAsRead($currentUser['id']);
    redirect(SITE_URL . '/notifications.php?tab=' . $tab);
}

// 标记单条通知为已读
if (isset($_GET['mark_read'])) {
    $notificationId = intval($_GET['mark_read']);
    markNotificationAsRead($notificationId, $currentUser['id']);
    // 如果有跳转链接，则跳转
    if (isset($_GET['redirect'])) {
        redirect($_GET['redirect']);
    }
    redirect(SITE_URL . '/notifications.php?tab=' . $tab);
}

// 获取各类通知数量
$unreadCounts = db()->queryOne(
    "SELECT 
        SUM(CASE WHEN is_read = 0 THEN 1 ELSE 0 END) as total_unread,
        SUM(CASE WHEN type = 'like' AND is_read = 0 THEN 1 ELSE 0 END) as like_unread,
        SUM(CASE WHEN type = 'favorite' AND is_read = 0 THEN 1 ELSE 0 END) as favorite_unread,
        SUM(CASE WHEN type = 'reply' AND is_read = 0 THEN 1 ELSE 0 END) as reply_unread
    FROM notifications WHERE user_id = ?",
    [$currentUser['id']]
);

$totalCounts = db()->queryOne(
    "SELECT 
        COUNT(*) as total,
        SUM(CASE WHEN type = 'like' THEN 1 ELSE 0 END) as like_count,
        SUM(CASE WHEN type = 'favorite' THEN 1 ELSE 0 END) as favorite_count,
        SUM(CASE WHEN type = 'reply' THEN 1 ELSE 0 END) as reply_count
    FROM notifications WHERE user_id = ?",
    [$currentUser['id']]
);

// 获取通知列表
if ($tab === 'all') {
    $notifications = getNotifications($currentUser['id'], $page, $perPage);
    $total = $totalCounts['total'] ?? 0;
} else {
    $notifications = getNotificationsByType($currentUser['id'], $tab, $page, $perPage);
    $total = $totalCounts[$tab . '_count'] ?? 0;
}

$pageTitle = '消息通知';
include __DIR__ . '/templates/header.php';

// 辅助函数：获取通知类型信息
function getNotificationTypeInfo($type) {
    switch ($type) {
        case 'like':
            return ['icon' => 'fa-thumbs-up', 'text' => '点赞', 'color' => '#ff6b6b'];
        case 'favorite':
            return ['icon' => 'fa-star', 'text' => '收藏', 'color' => '#f59e0b'];
        case 'reply':
            return ['icon' => 'fa-comment', 'text' => '回复', 'color' => '#2563eb'];
        case 'follow':
            return ['icon' => 'fa-user-plus', 'text' => '关注', 'color' => '#2563eb'];
        case 'medal_unlock':
            return ['icon' => 'fa-medal', 'text' => '勋章解锁', 'color' => '#d4a574'];
        case 'medal_unlocked':
            return ['icon' => 'fa-trophy', 'text' => '解锁成功', 'color' => '#2563eb'];
        default:
            return ['icon' => 'fa-bell', 'text' => '通知', 'color' => '#666'];
    }
}
?>

<div class="container" style="max-width: 1200px; margin: 20px auto; padding: 0 15px;">
    <div class="card" style="background: white; border-radius: 12px; box-shadow: 0 2px 8px rgba(0,0,0,0.08); overflow: hidden; border: 1px solid #e2e8f0;">
        <!-- 头部区域 - 蓝白色主题 -->
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center; padding: 20px 24px; background: #ffffff; color: #1e293b; border-bottom: 1px solid #e2e8f0;">
            <h1 style="font-size: 22px; margin: 0; font-weight: 600;"><i class="fas fa-bell" style="color: #2563eb; margin-right: 8px;"></i>消息通知</h1>
            <?php if ($totalCounts['total'] > 0): ?>
                <a href="?mark_all_read=1&tab=<?php echo $tab; ?>" 
                   style="background: #eff6ff; color: #2563eb; padding: 8px 16px; border-radius: 20px; text-decoration: none; font-size: 14px; transition: all 0.3s; border: 1px solid #bfdbfe;"
                   onmouseover="this.style.background='#dbeafe'"
                   onmouseout="this.style.background='#eff6ff'"
                   onclick="return confirm('确定要标记所有通知为已读吗？')">
                    <i class="fas fa-check-double"></i> 全部已读
                </a>
            <?php endif; ?>
        </div>

        <!-- 标签导航 - 蓝白色主题 -->
        <div style="display: flex; border-bottom: 1px solid #e2e8f0; background: #f8fafc;">
            <a href="?tab=all" style="flex: 1; text-align: center; padding: 16px; text-decoration: none; color: <?php echo $tab === 'all' ? '#2563eb' : '#64748b'; ?>; border-bottom: 3px solid <?php echo $tab === 'all' ? '#2563eb' : 'transparent'; ?>; font-weight: <?php echo $tab === 'all' ? 'bold' : 'normal'; ?>; transition: all 0.3s; font-size: 15px;">
                <i class="fas fa-bell"></i> 全部
                <?php if ($unreadCounts['total_unread'] > 0): ?>
                    <span style="background: #ef4444; color: white; font-size: 11px; padding: 2px 8px; border-radius: 10px; margin-left: 5px; font-weight: bold;"><?php echo $unreadCounts['total_unread']; ?></span>
                <?php endif; ?>
            </a>
            <a href="?tab=like" style="flex: 1; text-align: center; padding: 16px; text-decoration: none; color: <?php echo $tab === 'like' ? '#ef4444' : '#64748b'; ?>; border-bottom: 3px solid <?php echo $tab === 'like' ? '#ef4444' : 'transparent'; ?>; font-weight: <?php echo $tab === 'like' ? 'bold' : 'normal'; ?>; transition: all 0.3s; font-size: 15px;">
                <i class="fas fa-thumbs-up"></i> 点赞
                <?php if ($unreadCounts['like_unread'] > 0): ?>
                    <span style="background: #ef4444; color: white; font-size: 11px; padding: 2px 8px; border-radius: 10px; margin-left: 5px; font-weight: bold;"><?php echo $unreadCounts['like_unread']; ?></span>
                <?php endif; ?>
            </a>
            <a href="?tab=favorite" style="flex: 1; text-align: center; padding: 16px; text-decoration: none; color: <?php echo $tab === 'favorite' ? '#f59e0b' : '#64748b'; ?>; border-bottom: 3px solid <?php echo $tab === 'favorite' ? '#f59e0b' : 'transparent'; ?>; font-weight: <?php echo $tab === 'favorite' ? 'bold' : 'normal'; ?>; transition: all 0.3s; font-size: 15px;">
                <i class="fas fa-star"></i> 收藏
                <?php if ($unreadCounts['favorite_unread'] > 0): ?>
                    <span style="background: #ef4444; color: white; font-size: 11px; padding: 2px 8px; border-radius: 10px; margin-left: 5px; font-weight: bold;"><?php echo $unreadCounts['favorite_unread']; ?></span>
                <?php endif; ?>
            </a>
            <a href="?tab=reply" style="flex: 1; text-align: center; padding: 16px; text-decoration: none; color: <?php echo $tab === 'reply' ? '#2563eb' : '#64748b'; ?>; border-bottom: 3px solid <?php echo $tab === 'reply' ? '#2563eb' : 'transparent'; ?>; font-weight: <?php echo $tab === 'reply' ? 'bold' : 'normal'; ?>; transition: all 0.3s; font-size: 15px;">
                <i class="fas fa-comment"></i> 回复
                <?php if ($unreadCounts['reply_unread'] > 0): ?>
                    <span style="background: #ef4444; color: white; font-size: 11px; padding: 2px 8px; border-radius: 10px; margin-left: 5px; font-weight: bold;"><?php echo $unreadCounts['reply_unread']; ?></span>
                <?php endif; ?>
            </a>
        </div>

        <div class="notification-list" style="background: #ffffff;">
            <?php if (empty($notifications)): ?>
                <div style="padding: 80px 20px; text-align: center; color: #64748b; background: #ffffff;">
                    <div style="width: 100px; height: 100px; margin: 0 auto 24px; background: #eff6ff; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-bell-slash" style="font-size: 48px; color: #93c5fd;"></i>
                    </div>
                    <p style="font-size: 18px; color: #334155; margin-bottom: 8px;">暂无<?php echo $tab === 'all' ? '' : getNotificationTypeInfo($tab)['text']; ?>消息</p>
                    <p style="font-size: 14px; color: #94a3b8;">当有人<?php echo $tab === 'all' ? '点赞、收藏或回复' : getNotificationTypeInfo($tab)['text']; ?>你的内容时，会在这里显示</p>
                </div>
            <?php else: ?>
                <?php foreach ($notifications as $notification):
                    $typeInfo = getNotificationTypeInfo($notification['type']);

                    // 构建跳转链接
                    $redirectUrl = '';
                    $highlightId = '';
                    
                    // 勋章解锁通知特殊处理
                    $isMedalUnlock = ($notification['type'] === 'medal_unlock');
                    $isMedalUnlocked = ($notification['type'] === 'medal_unlocked');
                    $medalInfo = null;
                    if (($isMedalUnlock || $isMedalUnlocked) && $notification['related_id']) {
                        $medalInfo = db()->queryOne("SELECT * FROM medals WHERE id = ?", [$notification['related_id']]);
                        if ($isMedalUnlock) {
                            $redirectUrl = SITE_URL . '/medals.php?unlock=' . $notification['related_id'];
                        } else {
                            $redirectUrl = SITE_URL . '/medals.php';
                        }
                    } elseif ($notification['target_type'] && $notification['target_id']) {
                        if ($notification['target_type'] === 'post') {
                            $redirectUrl = SITE_URL . '/post.php?id=' . $notification['target_id'];
                            $highlightId = 'post-' . $notification['target_id'];
                        } else {
                            // 回复需要找到对应的帖子
                            $reply = db()->queryOne("SELECT post_id FROM replies WHERE id = ?", [$notification['target_id']]);
                            if ($reply) {
                                $redirectUrl = SITE_URL . '/post.php?id=' . $reply['post_id'] . '&highlight=reply-' . $notification['target_id'] . '&from_user=' . urlencode($notification['sender_name'] ?? '') . '&action=' . $notification['type'];
                                $highlightId = 'reply-' . $notification['target_id'];
                            }
                        }
                    }
                ?>
                    <div class="notification-item <?php echo $notification['is_read'] ? 'read' : 'unread'; ?>"
                         id="notification-<?php echo $notification['id']; ?>"
                         style="padding: 20px 24px; border-bottom: 1px solid #f1f5f9; display: flex; align-items: flex-start; gap: 16px; <?php echo $notification['is_read'] ? '' : 'background: #f8fafc;'; ?> transition: all 0.3s;">

                        <!-- 发送者头像 - 蓝白色主题 -->
                        <div class="notification-avatar" style="flex-shrink: 0;">
                            <?php if ($isMedalUnlock): ?>
                                <!-- 勋章解锁显示勋章图标 - 金色 -->
                                <div style="width: 52px; height: 52px; border-radius: 50%; background: #fef3c7; display: flex; align-items: center; justify-content: center; color: #d97706; font-size: 22px; border: 2px solid #fcd34d;">
                                    <i class="fas fa-medal"></i>
                                </div>
                            <?php elseif ($isMedalUnlocked): ?>
                                <!-- 解锁成功显示奖杯 - 蓝色 -->
                                <div style="width: 52px; height: 52px; border-radius: 50%; background: #dbeafe; display: flex; align-items: center; justify-content: center; color: #2563eb; font-size: 22px; border: 2px solid #93c5fd;">
                                    <i class="fas fa-trophy"></i>
                                </div>
                            <?php elseif ($notification['sender_avatar']): ?>
                                <a href="user.php?id=<?php echo $notification['sender_id']; ?>">
                                    <img src="<?php echo e($notification['sender_avatar']); ?>"
                                         alt="<?php echo e($notification['sender_name']); ?>"
                                         style="width: 52px; height: 52px; border-radius: 50%; object-fit: cover; display: block; border: 2px solid #e2e8f0;">
                                </a>
                            <?php else: ?>
                                <a href="user.php?id=<?php echo $notification['sender_id']; ?>">
                                    <div style="width: 52px; height: 52px; border-radius: 50%; background: #e2e8f0; display: flex; align-items: center; justify-content: center; color: #64748b; font-size: 22px;">
                                        <i class="fas fa-user"></i>
                                    </div>
                                </a>
                            <?php endif; ?>
                        </div>

                        <!-- 通知内容 -->
                        <div class="notification-content" style="flex: 1; min-width: 0;">
                            <div style="display: flex; align-items: center; gap: 8px; margin-bottom: 6px; flex-wrap: wrap;">
                                <span style="color: <?php echo $typeInfo['color']; ?>; font-size: 18px;">
                                    <i class="fas <?php echo $typeInfo['icon']; ?>"></i>
                                </span>
                                
                                <?php if ($isMedalUnlock): ?>
                                    <!-- 勋章解锁通知 -->
                                    <strong style="color: #d97706; font-size: 15px;">系统消息</strong>
                                    <span style="color: #64748b; font-size: 14px;">您有待解锁的勋章</span>
                                <?php elseif ($isMedalUnlocked): ?>
                                    <!-- 解锁成功通知 -->
                                    <strong style="color: #2563eb; font-size: 15px;">系统消息</strong>
                                    <span style="color: #64748b; font-size: 14px;">恭喜您成功解锁勋章</span>
                                <?php else: ?>
                                    <strong style="color: #334155; font-size: 15px;">
                                        <?php if ($notification['sender_name']): ?>
                                            <a href="user.php?id=<?php echo $notification['sender_id']; ?>" style="color: #2563eb; text-decoration: none;">
                                                <?php echo e($notification['sender_name']); ?>
                                            </a>
                                        <?php else: ?>
                                            系统
                                        <?php endif; ?>
                                    </strong>
                                    <span style="color: #64748b; font-size: 14px;"><?php echo $typeInfo['text']; ?>了你的<?php echo $notification['target_type'] === 'post' ? '帖子' : '回复'; ?></span>
                                <?php endif; ?>
                                
                                <?php if (!$notification['is_read']): ?>
                                    <span style="background: #ef4444; color: white; font-size: 11px; padding: 3px 8px; border-radius: 10px; font-weight: bold;">未读</span>
                                <?php endif; ?>
                            </div>

                            <?php if (($isMedalUnlock || $isMedalUnlocked) && $medalInfo): ?>
                                <!-- 勋章解锁/成功详情 - 蓝色边框 -->
                                <div style="color: #64748b; font-size: 14px; margin: 10px 0; padding: 14px; background: #f8fafc; border-radius: 10px; border-left: 4px solid <?php echo $isMedalUnlocked ? '#2563eb' : '#d97706'; ?>; display: flex; align-items: center; gap: 14px;">
                                    <img src="<?php echo SITE_URL . '/' . $medalInfo['icon']; ?>" alt="" style="width: 48px; height: 48px; object-fit: contain;">
                                    <div>
                                        <div style="font-weight: bold; color: #334155; font-size: 15px; margin-bottom: 4px;"><?php echo e($medalInfo['name']); ?></div>
                                        <div style="font-size: 13px; color: #64748b;"><?php echo e($medalInfo['description']); ?></div>
                                    </div>
                                </div>
                            <?php elseif ($notification['content']): ?>
                                <div style="color: #64748b; font-size: 14px; margin: 10px 0; padding: 14px; background: #f8fafc; border-radius: 10px; border-left: 4px solid <?php echo $typeInfo['color']; ?>;">
                                    <?php echo e($notification['content']); ?>
                                </div>
                            <?php endif; ?>

                            <div style="color: #94a3b8; font-size: 12px; margin-top: 8px;">
                                <i class="fas fa-clock" style="margin-right: 4px;"></i> <?php echo formatTime($notification['created_at']); ?>
                            </div>
                        </div>

                        <!-- 操作按钮 - 蓝白色主题 -->
                        <div class="notification-actions" style="display: flex; flex-direction: column; gap: 8px; flex-shrink: 0;">
                            <?php if ($redirectUrl): ?>
                                <a href="?mark_read=<?php echo $notification['id']; ?>&redirect=<?php echo urlencode($redirectUrl); ?>"
                                   style="background: <?php echo $isMedalUnlock ? '#f59e0b' : ($isMedalUnlocked ? '#2563eb' : '#2563eb'); ?>; color: white; padding: 10px 18px; border-radius: 8px; text-decoration: none; font-size: 13px; text-align: center; white-space: nowrap; transition: all 0.3s;"
                                   onmouseover="this.style.opacity='0.9'"
                                   onmouseout="this.style.opacity='1'">
                                    <i class="fas <?php echo $isMedalUnlock ? 'fa-medal' : ($isMedalUnlocked ? 'fa-trophy' : 'fa-eye'); ?>" style="margin-right: 4px;"></i> 
                                    <?php echo $isMedalUnlock ? '去解锁' : ($isMedalUnlocked ? '查看勋章' : '查看'); ?>
                                </a>
                            <?php endif; ?>
                            <?php if (!$notification['is_read']): ?>
                                <a href="?mark_read=<?php echo $notification['id']; ?>&tab=<?php echo $tab; ?>"
                                   style="background: transparent; color: #64748b; padding: 8px 16px; border-radius: 8px; text-decoration: none; font-size: 12px; text-align: center; white-space: nowrap; border: 1px solid #e2e8f0; transition: all 0.3s;"
                                   onmouseover="this.style.background='#f8fafc'; this.style.borderColor='#cbd5e1'"
                                   onmouseout="this.style.background='transparent'; this.style.borderColor='#e2e8f0'">
                                    <i class="fas fa-check" style="margin-right: 4px;"></i> 已读
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>

                <!-- 分页 -->
                <?php if ($total > $perPage): ?>
                    <div style="padding: 24px; background: #f8fafc;">
                        <?php echo pagination($total, $page, $perPage, 'notifications.php?tab=' . $tab . '&'); ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.notification-item:hover {
    background: #f8fafc !important;
}
.notification-item.unread {
    border-left: 4px solid #2563eb;
}
.notification-item.read {
    opacity: 0.85;
}
@keyframes highlight-pulse {
    0% { background-color: #eff6ff; }
    50% { background-color: #dbeafe; }
    100% { background-color: #eff6ff; }
}
.highlight-target {
    animation: highlight-pulse 2s ease-in-out;
    border-radius: 8px;
    padding: 10px;
}
</style>

<?php include __DIR__ . '/templates/footer.php'; ?>
