        </div>
    </main>



    <footer class="footer">
        <div class="container">
            <div class="footer-inner">
                <p>&copy; <?php echo date('Y'); ?> <?php echo e(getSetting('site_name', 'PHP论坛')); ?>. All rights reserved.</p>
                <p>Powered by PHP Forum</p>
            </div>
        </div>
    </footer>

    <script src="<?php echo SITE_URL; ?>/assets/js/main.js"></script>
    <script>
        // 楼中楼回复表单显示/隐藏
        function showReplyForm(replyId, username) {
            // 隐藏所有其他回复表单
            document.querySelectorAll('[id^="reply-form-"]').forEach(function(el) {
                el.style.display = 'none';
            });
            // 显示当前回复表单
            var form = document.getElementById('reply-form-' + replyId);
            if (form) {
                form.style.display = 'block';
                // 检查是否有富文本编辑器
                var editorContainer = form.querySelector('[id^="reply-editor-"]');
                if (editorContainer && typeof initSubReplyEditor === 'function') {
                    // 延迟初始化富文本编辑器
                    setTimeout(function() {
                        initSubReplyEditor(replyId);
                    }, 100);
                } else {
                    // 普通文本框
                    var textarea = form.querySelector('textarea');
                    if (textarea) {
                        textarea.focus();
                        textarea.placeholder = '回复 ' + username + '...';
                    }
                }
            }
        }
        
        function hideReplyForm(replyId) {
            var form = document.getElementById('reply-form-' + replyId);
            if (form) {
                form.style.display = 'none';
            }
        }
        
        // 折叠/展开整个楼中楼区域
        function toggleSubReplies(replyId) {
            var container = document.getElementById('sub-replies-' + replyId);
            var icon = document.getElementById('toggle-icon-' + replyId);
            var text = document.getElementById('toggle-text-' + replyId);
            
            if (container.style.display === 'none') {
                container.style.display = 'block';
                icon.className = 'fas fa-chevron-down';
                text.textContent = text.textContent.replace('展开', '收起');
            } else {
                container.style.display = 'none';
                icon.className = 'fas fa-chevron-right';
                text.textContent = text.textContent.replace('收起', '展开');
            }
        }
        
        // 折叠/展开单条回复
        function toggleSingleReply(replyId) {
            var content = document.getElementById('reply-content-' + replyId);
            var collapsed = document.getElementById('reply-collapsed-' + replyId);
            var icon = document.getElementById('single-icon-' + replyId);
            
            if (content.style.display === 'none') {
                content.style.display = 'block';
                collapsed.style.display = 'none';
                icon.className = 'fas fa-minus-square';
            } else {
                content.style.display = 'none';
                collapsed.style.display = 'block';
                icon.className = 'fas fa-plus-square';
            }
        }
        
        // 折叠/展开整个回复区域
        function toggleAllReplies() {
            var container = document.getElementById('all-replies-container');
            var icon = document.getElementById('toggle-all-icon');
            var text = document.getElementById('toggle-all-text');
            
            if (container.style.display === 'none') {
                container.style.display = 'block';
                icon.className = 'fas fa-chevron-down';
                text.textContent = '收起全部回复';
            } else {
                container.style.display = 'none';
                icon.className = 'fas fa-chevron-right';
                text.textContent = '展开全部回复';
            }
        }
        
        // 页面加载后滚动到指定位置
        window.onload = function() {
            // 如果有 hash，滚动到对应位置
            if (window.location.hash) {
                var element = document.querySelector(window.location.hash);
                if (element) {
                    setTimeout(function() {
                        element.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    }, 100);
                }
            }
        };
        
        // 提交表单前保存滚动位置
        document.querySelectorAll('form').forEach(function(form) {
            form.addEventListener('submit', function() {
                sessionStorage.setItem('scrollPosition', window.pageYOffset);
            });
        });
        
        // 页面加载后恢复滚动位置（如果没有 hash）
        if (!window.location.hash) {
            var savedPosition = sessionStorage.getItem('scrollPosition');
            if (savedPosition) {
                window.scrollTo(0, parseInt(savedPosition));
                sessionStorage.removeItem('scrollPosition');
            }
        }
    </script>
</body>
</html>
