<?php
require_once __DIR__ . '/../includes/functions.php';

// 使用不同的变量名避免覆盖页面中的 $user 变量
$currentUser = getCurrentUser();
$siteName = getSetting('site_name', SITE_NAME);
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? e($pageTitle) . ' - ' : ''; ?><?php echo e($siteName); ?></title>
    <meta name="description" content="<?php echo e(getSetting('site_description', '一个简洁优雅的PHP论坛系统')); ?>">
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/assets/css/style.css?v=2">
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>/assets/mobile/css/mobile.css?v=2">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <header class="header">
        <div class="container">
            <div class="header-inner">
                <a href="<?php echo SITE_URL; ?>/index.php" class="logo">
                    <i class="fas fa-comments"></i>
                    <span><?php echo e($siteName); ?></span>
                </a>
                
                <!-- 手机版搜索图标 -->
                <a href="<?php echo SITE_URL; ?>/search.php" class="mobile-search-btn">
                    <i class="fas fa-search"></i>
                </a>
                
                <nav class="nav">
                    <a href="<?php echo SITE_URL; ?>/index.php" class="nav-link">首页</a>
                    <a href="<?php echo SITE_URL; ?>/category.php" class="nav-link">板块</a>
                </nav>
                
                <!-- PC版搜索框 -->
                <div class="header-search">
                    <form action="<?php echo SITE_URL; ?>/search.php" method="get">
                        <input type="text" name="q" placeholder="搜索帖子..." required>
                        <button type="submit"><i class="fas fa-search"></i></button>
                    </form>
                </div>
                
                <div class="header-right">
                    <?php if ($currentUser): ?>
                        <!-- 通知图标 -->
                        <?php
                        $unreadCount = getUnreadNotificationCount($currentUser['id']);
                        ?>
                        <a href="<?php echo SITE_URL; ?>/notifications.php" class="notification-icon" style="position: relative; margin-right: 15px; color: #666; font-size: 20px; padding: 8px; border-radius: 50%; transition: all 0.3s;">
                            <i class="fas fa-bell"></i>
                            <?php if ($unreadCount > 0): ?>
                                <span class="notification-badge" style="position: absolute; top: 0; right: 0; background: #ff6b6b; color: white; font-size: 11px; min-width: 18px; height: 18px; border-radius: 9px; display: flex; align-items: center; justify-content: center; padding: 0 5px; font-weight: bold;">
                                    <?php echo $unreadCount > 99 ? '99+' : $unreadCount; ?>
                                </span>
                            <?php endif; ?>
                        </a>
                        <div class="user-menu">
                            <a href="<?php echo SITE_URL; ?>/user.php?id=<?php echo $currentUser['id']; ?>" class="user-info">
                                <div class="avatar">
                                    <?php if ($currentUser['avatar']): ?>
                                        <img src="<?php echo e($currentUser['avatar']); ?>" alt="<?php echo e($currentUser['username']); ?>">
                                    <?php else: ?>
                                        <i class="fas fa-user"></i>
                                    <?php endif; ?>
                                </div>
                                <span><?php echo e($currentUser['username']); ?></span>
                                <?php if ($currentUser['role'] == 2): ?>
                                    <span class="badge" style="background: #e74c3c;">超管</span>
                                <?php elseif ($currentUser['role'] == 1): ?>
                                    <span class="badge admin">管理员</span>
                                <?php endif; ?>
                            </a>
                            <div class="dropdown">
                                <a href="<?php echo SITE_URL; ?>/user.php?id=<?php echo $currentUser['id']; ?>"><i class="fas fa-user-circle"></i> 个人中心</a>
                                <a href="<?php echo SITE_URL; ?>/medals.php"><i class="fas fa-medal"></i> 我的勋章</a>
                                <a href="<?php echo SITE_URL; ?>/notifications.php">
                                    <i class="fas fa-bell"></i> 消息通知
                                    <?php if ($unreadCount > 0): ?>
                                        <span style="background: #ff6b6b; color: white; font-size: 11px; padding: 2px 6px; border-radius: 10px; margin-left: 5px;"><?php echo $unreadCount; ?></span>
                                    <?php endif; ?>
                                </a>
                                <a href="<?php echo SITE_URL; ?>/settings.php"><i class="fas fa-cog"></i> 设置</a>
                                <?php if ($currentUser['role'] >= 1): ?>
                                    <a href="<?php echo SITE_URL; ?>/admin/"><i class="fas fa-crown"></i> 管理后台</a>
                                <?php endif; ?>
                                <div class="divider"></div>
                                <a href="<?php echo SITE_URL; ?>/logout.php"><i class="fas fa-sign-out-alt"></i> 退出登录</a>
                            </div>
                        </div>
                    <?php else: ?>
                        <a href="<?php echo SITE_URL; ?>/login.php" class="btn btn-outline">登录</a>
                        <a href="<?php echo SITE_URL; ?>/register.php" class="btn btn-primary">注册</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </header>

    <main class="main">
        <div class="container">
