<?php
/**
 * 测试 POST 数据接收
 */
require_once __DIR__ . '/includes/functions.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    echo json_encode([
        'post_data' => $_POST,
        'content_length' => strlen($_POST['content'] ?? ''),
        'content_value' => $_POST['content'] ?? '(empty)',
        'raw_input' => file_get_contents('php://input'),
    ]);
    exit;
}

$pageTitle = '测试 POST 数据';
include __DIR__ . '/templates/header.php';
?>

<div class="card">
    <div class="card-header">
        <h2>测试 POST 数据接收</h2>
    </div>
    <div class="card-body">
        <form method="POST" action="" id="test-form">
            <div class="form-group">
                <label>内容</label>
                <div id="editor-container" style="height: 200px; border: 1px solid #ddd;"></div>
                <input type="hidden" name="content" id="content-input">
            </div>
            <button type="submit" class="btn btn-primary">提交测试</button>
        </form>
        
        <div id="result" style="margin-top: 20px; padding: 15px; background: #f5f5f5; border-radius: 8px; display: none;">
            <h4>测试结果：</h4>
            <pre id="result-content"></pre>
        </div>
    </div>
</div>

<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
<script>
    var quill = new Quill('#editor-container', {
        theme: 'snow',
        placeholder: '请输入内容...',
        modules: {
            toolbar: [['bold', 'italic'], ['link']]
        }
    });
    
    document.getElementById('test-form').addEventListener('submit', function(e) {
        e.preventDefault();
        
        var htmlContent = quill.root.innerHTML;
        document.getElementById('content-input').value = htmlContent;
        
        console.log('Sending content:', htmlContent);
        console.log('Content length:', htmlContent.length);
        
        var formData = new FormData(this);
        
        fetch('', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            document.getElementById('result').style.display = 'block';
            document.getElementById('result-content').textContent = JSON.stringify(data, null, 2);
        })
        .catch(error => {
            console.error('Error:', error);
            alert('请求失败: ' + error);
        });
    });
</script>

<?php include __DIR__ . '/templates/footer.php'; ?>
