<?php
/**
 * 数据库升级脚本 - 添加 is_locked 字段到 posts 表
 */
require_once __DIR__ . '/includes/functions.php';

try {
    // 检查字段是否已存在
    $result = db()->queryOne("SHOW COLUMNS FROM posts LIKE 'is_locked'");
    
    if (!$result) {
        // 添加 is_locked 字段
        db()->execute("ALTER TABLE posts ADD COLUMN is_locked TINYINT UNSIGNED DEFAULT 0 COMMENT '是否锁定: 0否, 1是' AFTER is_essence");
        
        // 添加索引
        db()->execute("ALTER TABLE posts ADD INDEX idx_is_locked (is_locked)");
        
        echo "✓ 数据库升级成功！已添加 is_locked 字段到 posts 表。";
    } else {
        echo "✓ 字段已存在，无需升级。";
    }
} catch (Exception $e) {
    echo "✗ 升级失败：" . $e->getMessage();
}
?>
