<?php
/**
 * 更新数据库 - 添加勋章系统
 */
require_once __DIR__ . '/includes/functions.php';

echo "<h2>正在更新数据库 - 添加勋章系统...</h2>";

try {
    // 创建勋章表
    $sql = "CREATE TABLE IF NOT EXISTS medals (
        id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100) NOT NULL COMMENT '勋章名称',
        description VARCHAR(500) DEFAULT NULL COMMENT '勋章描述',
        icon VARCHAR(255) NOT NULL COMMENT '勋章图标路径',
        type VARCHAR(50) NOT NULL COMMENT '勋章类型: bookmark收藏, comment评论, like点赞',
        condition_type VARCHAR(50) NOT NULL COMMENT '条件类型: post_favorited帖子被收藏数, reply_count回复数, post_liked帖子被点赞数',
        condition_value INT UNSIGNED NOT NULL COMMENT '条件数值',
        sort_order INT UNSIGNED DEFAULT 0 COMMENT '排序',
        status TINYINT UNSIGNED DEFAULT 1 COMMENT '状态: 0禁用, 1启用',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_type (type),
        INDEX idx_status (status),
        INDEX idx_sort (sort_order)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='勋章表';
    ";
    
    db()->execute($sql);
    echo "<p>✓ 勋章表创建成功</p>";
    
    // 创建用户勋章表
    $sql2 = "CREATE TABLE IF NOT EXISTS user_medals (
        id INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        user_id INT UNSIGNED NOT NULL COMMENT '用户ID',
        medal_id INT UNSIGNED NOT NULL COMMENT '勋章ID',
        is_wearing TINYINT UNSIGNED DEFAULT 0 COMMENT '是否佩戴: 0否, 1是',
        awarded_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP COMMENT '获得时间',
        UNIQUE KEY uk_user_medal (user_id, medal_id),
        INDEX idx_user_id (user_id),
        INDEX idx_is_wearing (is_wearing),
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
        FOREIGN KEY (medal_id) REFERENCES medals(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='用户勋章表';
    ";
    
    db()->execute($sql2);
    echo "<p>✓ 用户勋章表创建成功</p>";
    
    // 插入默认勋章数据
    $medals = [
        ['收藏达人', '发布的帖子被收藏12次', 'assets/images/Medal/Bookmark.png', 'bookmark', 'post_favorited', 12, 1],
        ['评论先锋', '参与50次评论', 'assets/images/Medal/Comment.png', 'comment', 'reply_count', 50, 2],
        ['人气作者', '发布的帖子被点赞20次', 'assets/images/Medal/Like.png', 'like', 'post_liked', 20, 3]
    ];
    
    foreach ($medals as $medal) {
        // 检查是否已存在
        $exists = db()->queryOne("SELECT id FROM medals WHERE type = ?", [$medal[3]]);
        if (!$exists) {
            db()->execute(
                "INSERT INTO medals (name, description, icon, type, condition_type, condition_value, sort_order) VALUES (?, ?, ?, ?, ?, ?, ?)",
                $medal
            );
            echo "<p>✓ 勋章 '{$medal[0]}' 添加成功</p>";
        } else {
            echo "<p>○ 勋章 '{$medal[0]}' 已存在，跳过</p>";
        }
    }
    
    echo "<h3 style='color: green;'>✓ 数据库更新完成！</h3>";
    echo "<p><a href='medals.php'>前往我的勋章页面</a></p>";
    
} catch (Exception $e) {
    echo "<h3 style='color: red;'>✗ 错误: " . $e->getMessage() . "</h3>";
}
